<?php
namespace Janolaw\Agb\Block;

use \Magento\Framework\View\Element\Template;

class Term extends Template
{
    /**
     * @var string
     */
    protected $_template = 'term.phtml';

    /**
     * @var \Janolaw\Agb\Model\TermFactory
     */
    protected $_termFactory;

    /**
     * @param \Magento\Framework\View\Element\Template\Context $context
     * @param \Janolaw\Agb\Model\TermFactory $termFactory
     * @param array $data
     * @codeCoverageIgnore
     */
    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \Janolaw\Agb\Model\TermFactory $termFactory,
        array $data = []
    ) {
        $this->_termFactory = $termFactory;
        parent::__construct($context, $data);
    }

    /**
     * @return string
     */
    public function getContent()
    {
        $content = '';
        $id = (int)$this->getId();

        if ($id) {
            /** @var \Janolaw\Agb\Model\Term $term */
            $term = $this->_termFactory->create()->load($this->getId());
            if ($term->getId() && $term->getContent()) {
                $content = $term->getContent();
            }
        }

        return $content;
    }
}
