<?php
namespace Janolaw\Agb\Model;

class AttachmentContainer
{
    protected $attachments = [];

    /**
     * @return bool
     */
    public function hasAttachments()
    {
        return sizeof($this->attachments) >= 1;
    }

    /**
     * @param \Janolaw\Agb\Model\Attachment $attachment
     */
    public function addAttachment(\Janolaw\Agb\Model\Attachment $attachment)
    {
        $this->attachments[] = $attachment;
    }

    /**
     * @return array
     */
    public function getAttachments()
    {
        return $this->attachments;
    }

    /**
     * @return void
     */
    public function resetAttachments()
    {
        $this->attachments = [];
    }
}
