<?php

namespace Janolaw\Agb\Model\Config\Source;

use \Janolaw\Agb\Model\Download;

/**
 * Used in creating options for commetns config value selection
 *
 */
class Language implements \Magento\Framework\Option\ArrayInterface
{
    protected $_download;

    /**
     * Constructor
     *
     * @param Download $download
     */
    public function __construct(
        Download $download
    ) {
        $this->_download = $download;
    }


    /**
     * Options getter
     *
     * @return array
     */
    public function toOptionArray()
    {
        $options = $this->_download->getLanguages();

        $return = [];
        foreach ($options as $value => $label) {
            $return[] = [
                'value' => $value,
                'label' => $label
            ];
        }

        return $return;
    }

    /**
     * Get options in "key-value" format
     *
     * @return array
     */
    public function toArray()
    {
        $array = [];
        foreach ($this->toOptionArray() as $item) {
            $array[$item['value']] = $item['label'];
        }
        return $array;
    }
}
