<?php

namespace Janolaw\Agb\Model\Overwrite;

use Magento\Store\Model\ScopeInterface;
use Magento\CheckoutAgreements\Model\AgreementsProvider;

class AgreementsConfigProvider extends \Magento\CheckoutAgreements\Model\AgreementsConfigProvider
{
    /**
     * @var \Magento\Cms\Model\Template\FilterProvider
     */
    protected $_filterProvider;

    /**
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfiguration
     * @param \Magento\CheckoutAgreements\Api\CheckoutAgreementsRepositoryInterface $checkoutAgreementsRepository
     * @param \Magento\Framework\Escaper $escaper
     * @param \Magento\Cms\Model\Template\FilterProvider $filterProvider
     * @codeCoverageIgnore
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfiguration,
        \Magento\CheckoutAgreements\Api\CheckoutAgreementsRepositoryInterface $checkoutAgreementsRepository,
        \Magento\Framework\Escaper $escaper,
        \Magento\Cms\Model\Template\FilterProvider $filterProvider
    ) {
        $this->scopeConfiguration = $scopeConfiguration;
        $this->checkoutAgreementsRepository = $checkoutAgreementsRepository;
        $this->escaper = $escaper;

        $this->_filterProvider = $filterProvider;

        parent::__construct(
            $scopeConfiguration,
            $checkoutAgreementsRepository,
            $escaper
        );
    }

    /**
     * Returns agreements config
     *
     * @return array
     */
    protected function getAgreementsConfig()
    {
        $agreementConfiguration = [];
        $isAgreementsEnabled = $this->scopeConfiguration->isSetFlag(
            AgreementsProvider::PATH_ENABLED,
            ScopeInterface::SCOPE_STORE
        );

        $agreementsList = $this->checkoutAgreementsRepository->getList();
        $agreementConfiguration['isEnabled'] = (bool)($isAgreementsEnabled && count($agreementsList) > 0);

        foreach ($agreementsList as $agreement) {
            //Added filter
            $content = $this->_filterProvider->getPageFilter()->filter($agreement->getContent());

            $agreementConfiguration['agreements'][] = [
                'content' => $agreement->getIsHtml()
                    ? $content
                    : nl2br($this->escaper->escapeHtml($content)),
                'checkboxText' => $agreement->getCheckboxText(),
                'mode' => $agreement->getMode(),
                'agreementId' => $agreement->getAgreementId()
            ];
        }

        return $agreementConfiguration;
    }
}
