<?php
namespace Janolaw\Agb\Block\Adminhtml\Renderer;

class Usage extends \Magento\Backend\Block\Widget\Grid\Column\Renderer\AbstractRenderer
{

    /**
     * Renders usage code
     *
     * @param \Magento\Framework\DataObject $item
     * @return string
     */
    public function render(\Magento\Framework\DataObject $item)
    {
        $this->setItem($item);
        $id = $item->getData('term_id');
        $type = $item->getData('type');
        $language = $item->getData('language');
        $name = $type . '_' . $language;

        $content = '{{block class="Janolaw\\\Agb\\\Block\\\Term" id="' . $id . '" area="frontend"}}';
        return $this->escapeHtml($content);
    }

    /**
     * Render product item with options
     *
     * @param Product $product
     * @param array $options
     * @return string
     */
    protected function _renderItemOptions(Product $product, array $options)
    {
        $html = '<div class="product-title">' . $this->escapeHtml(
            $product->getName()
        ) . '</div>' . '<dl class="item-options">';
        foreach ($options as $option) {
            $formattedOption = $this->getFormattedOptionValue($option);
            $html .= '<dt>' . $this->escapeHtml($option['label']) . '</dt>';
            $html .= '<dd>' . $formattedOption['value'] . '</dd>';
        }
        $html .= '</dl>';

        return $html;
    }
}
