<?php
namespace Janolaw\Agb\Controller\Adminhtml;

use Magento\Backend\App\Action;
use \Magento\Backend\App\Action\Context;
use \Magento\Framework\Registry;

/**
 * Manage Janolaw AGB Term Controller
 */
abstract class Term extends Action
{
    const ADMIN_RESOURCE = 'Janolaw_Agb::term';

    /**
     * Core registry
     *
     * @var \Magento\Framework\Registry
     */
    protected $_coreRegistry = null;

    /**
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Magento\Framework\Registry $coreRegistry
     * @codeCoverageIgnore
     */
    public function __construct(
        Context $context,
        Registry $coreRegistry
    ) {
        $this->_coreRegistry = $coreRegistry;
        parent::__construct($context);
    }

    /**
     * Init action
     *
     * @return $this
     */
    protected function _initAction()
    {
        $this->_view->loadLayout();
        $this->_setActiveMenu(self::ADMIN_RESOURCE)
            ->_addBreadcrumb(
                __('Janolaw AGB'),
                __('Janolaw AGB')
            );
        return $this;
    }
}
