<?php
namespace Janolaw\Agb\Controller\Adminhtml\Term;

use Janolaw\Agb\Model\Download;
use \Magento\Backend\App\Action;
use \Magento\Framework\Exception\ValidatorException;
use \Magento\Framework\Exception\RemoteServiceUnavailableException;
use \Magento\Framework\Exception\NoSuchEntityException;
use \Magento\Backend\App\Action\Context;

/**
 * Term synch controller
 */
class Synch extends Action
{
    protected $_downloadFactory;
    protected $_logger;

    /**
     * @param Context $context
     * @param \Psr\Log\LoggerInterface $logger
     * @param \Janolaw\Agb\Model\DownloadFactory $downloadFactory
     */
    public function __construct(
        Context $context,
        \Psr\Log\LoggerInterface $logger,
        \Janolaw\Agb\Model\DownloadFactory $downloadFactory
    ) {
        $this->_logger = $logger;
        $this->_downloadFactory = $downloadFactory;
        parent::__construct($context);
    }

    /**
     * @return void
     */
    public function execute()
    {
        try {
            /** @var Download $download */
            $download = $this->_downloadFactory->create();
            $download->execute();

            $loggedActions = $download->getLoggedActions();
            $error = false;

            //No content from service. Something wrong with User-ID or Shop-ID
            if (!isset($loggedActions['content']) || (isset($loggedActions['content']) && !count($loggedActions['content']))) {
                $error = true;
                $this->messageManager->addError(__('Please check, if shop User-ID and Shop-ID are correct.'));
            }

            //No pdf from service. It could not updated account
            if (!isset($loggedActions['pdf']) || (isset($loggedActions['pdf']) && !count($loggedActions['pdf']))) {
                if (!$error) {
                    $error = false;
                    $this->messageManager->addNotice(__('Please check, if you have booked the multi-language option of the janolaw service.'));
                }
            }

            //Some of records are deleted.
            if (isset($loggedActions['delete']) && count($loggedActions['delete'])) {
                $this->messageManager->addNotice(__('Some of records are removed. It is not possible to use them anymore. Please check all places where usage code was placed.'));
            }

            //New records are added.
            if (isset($loggedActions['create']) && count($loggedActions['create'])) {
                $this->messageManager->addNotice(__('New records are added. You can use them now.'));
            }

            //Everything is OK
            if (!$error) {
                $this->messageManager->addSuccess(__('Data is synchronized.'));
            }
        } catch (ValidatorException $e) {
            $this->messageManager->addError($e->getMessage());
        } catch (RemoteServiceUnavailableException $e) {
            $this->messageManager->addError($e->getMessage());
        } catch (NoSuchEntityException $e) {
            $this->messageManager->addError($e->getMessage());
        } catch (\Zend_Pdf_Exception $e) {
            $this->messageManager->addError($e->getMessage());
        } catch (\Exception $e) {
            $message = __("Something is wrong during synchronization.");

            $this->messageManager->addException($e, $message);

            $this->_logger->addDebug($message);
            $this->_logger->addDebug($e->getMessage());
        }

        $this->_redirect('*/*/index');
    }
}
