<?php

namespace Janolaw\Agb\Helper;

use \Magento\Framework\Exception\RemoteServiceUnavailableException;
use \Magento\Framework\Exception\NoSuchEntityException;

class Request extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var Zend_Http_Client
     */
    protected $_client = null;

    /**
     * @var \Magento\Framework\HTTP\Adapter\CurlFactory
     */
    protected $_curlFactory;

    /**
     * Time out for HTTP verification request
     *
     * @var int
     */
    private $_verificationTimeOut = 2;

    /**
     * @param \Magento\Framework\HTTP\Adapter\CurlFactory $curlFactory
     */
    public function __construct(\Magento\Framework\HTTP\Adapter\CurlFactory $curlFactory)
    {
        $this->_curlFactory = $curlFactory;
    }

    /**
     * @param $url
     * @return string
     * @throws RemoteServiceUnavailableException
     */
    public function getRemoteContent($url)
    {
        /** @var $http \Magento\Framework\HTTP\Adapter\Curl */
        $http = $this->_curlFactory->create();
        $http->setConfig(['keepalive' => true]);
        $http->write(\Zend_Http_Client::POST, $url);
        $responseBody = $http->read();
        $responseCode = \Zend_Http_Response::extractCode($responseBody);

        $responseBody = preg_split('/^\r?$/m', $responseBody, 2);
        $responseBody = trim($responseBody[1]);

        $http->close();

        if (($responseCode < 200 || $responseCode >= 300) && $responseCode != 404) {
            $reason = "Invalid response. Status: %1";
            throw new RemoteServiceUnavailableException(__($reason, $responseCode)->__toString());
        }

        if ($responseCode == 404) {
            $responseBody = '';
        }

        return $responseBody;
    }
}
