<?php

namespace Janolaw\Agb\Model;

/**
 * Cron wrap class
 */
class Cron
{
    protected $_downloadFactory;
    protected $_logger;

    /**
     * @param \Psr\Log\LoggerInterface $logger
     * @param \Janolaw\Agb\Model\DownloadFactory DownloadFactory $downloadFactory
     */
    public function __construct(
        \Psr\Log\LoggerInterface $logger,
        \Janolaw\Agb\Model\DownloadFactory $downloadFactory
    ) {
        $this->_logger = $logger;
        $this->_downloadFactory = $downloadFactory;
    }

    /**
     * @return void
     */
    public function runScheduledSynch()
    {
        try {
            $download = $this->_downloadFactory->create();
            $download->execute();
        } catch (\Exception $e) {
            $this->_logger->addDebug($e->getMessage());
        }
    }
}
