<?php

namespace Janolaw\Agb\Model;

use \Magento\Framework\Exception\ValidatorException;

/**
 * Demand model
 */
class Demand extends \Magento\Framework\Model\AbstractModel
{
    // api settings
    const CONFIG_PATH_SHOP_ID = 'janolawagb/user/shopid';
    const CONFIG_PATH_USER_ID = 'janolawagb/user/userid';
    const CONFIG_PATH_API_BASE_URL = 'janolawagb/user/api_base_url';
    const CONFIG_PATH_LANGUAGE = 'janolawagb/user/language';

    /**
     * @var \Janolaw\Agb\Helper\Request
     */
    private $_requestHelper;
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    private $_scopeConfig;
    /**
     * To prevent additional loading of the same texts for multiple stores...
     * @var array
     */
    protected $_urlCache = [];

    /**
     * Constructor
     *
     * @param \Magento\Framework\Model\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Janolaw\Agb\Helper\Request $requestHelper
     */
    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Janolaw\Agb\Helper\Request $requestHelper
    ) {
        $this->_scopeConfig = $scopeConfig;
        $this->_requestHelper = $requestHelper;
        parent::__construct($context, $registry);
    }

    /**
     * @param $filename
     * @param $language
     * @return mixed
     * @throws ValidatorException
     */
    public function fetch($filename, $language)
    {
        $url = $this->_buildApiUrl($filename, $language);
        $content = $this->_getRemoteContent($url);

        return $content;
    }

    /**
     * @param $url
     * @return mixed
     * @throws ValidatorException
     */
    public function fetchByUrl($url)
    {
        $content = $this->_getRemoteContent($url);

        return $content;
    }

    /**
     * Build url from Magento config (base url, shop id and user id) and filename.
     *
     * @param $fileName
     * @param $language_code
     *
     * @return string
     * @throws ValidatorException
     */
    protected function _buildApiUrl($fileName, $language_code)
    {
        $baseUrl = $this->_scopeConfig->getValue(self::CONFIG_PATH_API_BASE_URL);
        $userId = $this->_scopeConfig->getValue(self::CONFIG_PATH_USER_ID);
        $shopId = $this->_scopeConfig->getValue(self::CONFIG_PATH_SHOP_ID);
        $shopId = trim($shopId);
        $userId = trim($userId);
        $baseUrl = trim($baseUrl);

        if (!$baseUrl || !$userId || !$shopId) {
            throw new ValidatorException(__('Unsufficient configuration data. Add base url, user id and shop id configuration.'));
        }

        $apiUrl = rtrim($baseUrl, '/\\') . '/' . urlencode($userId) . '/' . urlencode($shopId) . '/'
            . urlencode($language_code) . '/' . $fileName;

        return $apiUrl;
    }

    /**
     * @param $url
     * @return mixed
     * @throws \Magento\Framework\Exception\RemoteServiceUnavailableException
     */
    protected function _getRemoteContent($url)
    {
        if (!isset($this->_urlCache[$url])) {
            $this->_urlCache[$url] = $this->_requestHelper->getRemoteContent($url);
        }
        return $this->_urlCache[$url];
    }
}
