<?php
namespace Janolaw\Agb\Model\Overwrite;

use Zend\Mime\Mime;
use Zend\Mime\Part;

/**
 * Class Message
 * This class complete overwrites parent class
 * The main method is setBody
 *
 * Magento 2.0, 2.1, 2,2 uses zendframework1 with Zend_Mail
 * ready attachment function
 *
 * Magento 2.3 does not have this function
 *
 * @see https://community.magento.com/t5/Magento-DevBlog/From-PHP-7-0-to-PHP-7-2-in-Magento-2-3/ba-p/91371
 * We have to overwrite complete parent \Magento\Framework\Mail\Message class
 * with all private properties
 *
 * @package Janolaw\Agb\Model\Overwrite
 */
class Message extends \Magento\Framework\Mail\Message
{
    /**
     * Zend\Mime\Part parts
     * @var array
     */
    private $attachmentParts = array();


    /**
     * Overwrites setBody with attachment part
     * @param $body
     *
     * @return $this|\Magento\Framework\Mail\Message
     */
    public function setBody($body){
            if (is_string($body) && $this->messageType === self::TYPE_HTML) {

                $body = self::createHtmlMimeFromString($body);

                //Overwrite begin
                //Add attachment
                if(count($this->getAttachmentParts())){
                    foreach ($this->getAttachmentParts() as $attachmentPart) {
                        $body->addPart($attachmentPart);
                    }
                }
                //Overwrite end
            }
            $this->zendMessage->setBody($body);

        return $this;
    }

    /**
     * Create an attachment
     * This is for Magento 2.3
     *
     * @param      $body
     * @param      $mimeType
     * @param      $disposition
     * @param      $encoding
     * @param null $filename
     *
     * @return mixed
     */
    public function createAttachment($body,
        $mimeType,
        $disposition,
        $encoding,
        $filename = null)
    {
        $mp = new Part($body);
        $mp->encoding = $encoding;
        $mp->type = $mimeType;
        $mp->disposition = $disposition;
        $mp->filename = $filename;

        $this->addAttachmentPart($mp);

        $result = $mp;


        return $result;
    }

    /**
     * @return array
     */
    public function getAttachmentParts()
    {
        return $this->attachmentParts;
    }

    /**
     * @param array $attachmentParts
     */
    public function setAttachmentParts($attachmentParts)
    {
        $this->attachmentParts = $attachmentParts;
    }

    /**
     * @param Part $attachmentPart
     */
    public function addAttachmentPart(Part $attachmentPart)
    {
        $this->attachmentParts[] = $attachmentPart;
    }

/** *************** COPY of Original Class **************************** */


    /**
     * @var \Zend\Mail\Message
     */
    private $zendMessage;

    /**
     * Message type
     *
     * @var string
     */
    protected $messageType = self::TYPE_TEXT;

    /**
     * Initialize dependencies.
     *
     * @param string $charset
     */
    public function __construct($charset = 'utf-8')
    {
        $this->zendMessage = new \Zend\Mail\Message();
        $this->zendMessage->setEncoding($charset);
    }

    /**
     * {@inheritdoc}
     *
     * @deprecated
     * @see \Magento\Framework\Mail\Message::setBodyText
     * @see \Magento\Framework\Mail\Message::setBodyHtml
     */
    public function setMessageType($type)
    {
        $this->messageType = $type;
        return $this;
    }

    /**
     * {@inheritdoc}
     */
    public function setSubject($subject)
    {
        $this->zendMessage->setSubject($subject);
        return $this;
    }

    /**
     * {@inheritdoc}
     */
    public function getSubject()
    {
        return $this->zendMessage->getSubject();
    }

    /**
     * {@inheritdoc}
     */
    public function getBody()
    {
        return $this->zendMessage->getBody();
    }

    /**
     * {@inheritdoc}
     */
    public function setFrom($fromAddress)
    {
        $this->zendMessage->setFrom($fromAddress);
        return $this;
    }

    /**
     * {@inheritdoc}
     */
    public function addTo($toAddress)
    {
        $this->zendMessage->addTo($toAddress);
        return $this;
    }

    /**
     * {@inheritdoc}
     */
    public function addCc($ccAddress)
    {
        $this->zendMessage->addCc($ccAddress);
        return $this;
    }

    /**
     * {@inheritdoc}
     */
    public function addBcc($bccAddress)
    {
        $this->zendMessage->addBcc($bccAddress);
        return $this;
    }

    /**
     * {@inheritdoc}
     */
    public function setReplyTo($replyToAddress)
    {
        $this->zendMessage->setReplyTo($replyToAddress);
        return $this;
    }

    /**
     * {@inheritdoc}
     */
    public function getRawMessage()
    {
        return $this->zendMessage->toString();
    }

    /**
     * Create HTML mime message from the string.
     *
     * @param string $htmlBody
     * @return \Zend\Mime\Message
     */
    private function createHtmlMimeFromString($htmlBody)
    {
        $htmlPart = new Part($htmlBody);
        $htmlPart->setCharset($this->zendMessage->getEncoding());
        $htmlPart->setType(Mime::TYPE_HTML);
        $mimeMessage = new \Zend\Mime\Message();
        $mimeMessage->addPart($htmlPart);
        return $mimeMessage;
    }

    /**
     * {@inheritdoc}
     */
    public function setBodyHtml($html)
    {
        $this->setMessageType(self::TYPE_HTML);
        return $this->setBody($html);
    }

    /**
     * {@inheritdoc}
     */
    public function setBodyText($text)
    {
        $this->setMessageType(self::TYPE_TEXT);
        return $this->setBody($text);
    }

    /**
     * @inheritdoc
     */
    public function setFromAddress($fromAddress, $fromName = null)
    {
        $this->zendMessage->setFrom($fromAddress, $fromName);
        return $this;
    }

}
