<?php

namespace Janolaw\Agb\Model;

use \Magento\Framework\Model\AbstractModel;

/**
 * Term model
 *
 * @method ResourceModel\Term _getResource()
 * @method ResourceModel\Term getResource()
 * @method string getType()
 * @method $this setType(string $value)
 * @method string getLanguage()
 * @method $this setLanguage(string $value)
 * @method string getContent()
 * @method $this setContent(string $value)
 * @method string getUsage()
 * @method $this setUsage(string $value)
 */
class Term extends AbstractModel
{

    /**
     * Prefix of model events names
     *
     * @var string
     */
    protected $_eventPrefix = 'janolaw_agb_term';

    /**
     * Parameter name in event
     *
     * In observe method you can use $observer->getEvent()->getObject() in this case
     *
     * @var string
     */
    protected $_eventObject = 'agb_term';


    /**
     * Initialize dependencies.
     *
     * @param \Magento\Framework\Model\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Framework\Model\ResourceModel\AbstractResource $resource
     * @param \Magento\Framework\Data\Collection\AbstractDb $resourceCollection
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Model\ResourceModel\AbstractResource $resource = null,
        \Magento\Framework\Data\Collection\AbstractDb $resourceCollection = null,
        array $data = []
    ) {
        parent::__construct($context, $registry, $resource, $resourceCollection, $data);
    }

    /**
     * Initialize resource model
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init('Janolaw\Agb\Model\ResourceModel\Term');
    }

    /**
     * Load report by unique key (accoutn + report date)
     *
     * @return $this
     */
    public function loadByTypeAndLanguage()
    {
        $this->getResource()->loadByTypeAndLanguage($this, $this->getAccountId(), $this->getReportDate());
        return $this;
    }
}
