Janolaw_Agb
============

Description
-----------

This module stores legal data (terms and condition, revocation, data privacy, imprint) hosted on `Janolaw` in the
shop database. It provides methods to synchronize the data on a regular basis (or manually in adminhtml panel if
you wish).

Features
--------

* Synchronizing texts from *janolaw* with special template blocks.
* Run synchronization manually in the adminhtml panel or manually via a (php) shell script.
* Setup page in adminhtml to help configuring the module
* Status page in adminhtml to show configuration status and data of last synchronization (success, errors and time).
  This is also where the button is provided to start synchronization.


Installation
------------
* Download ZIP Archive
* Extract files
* Copy "app" folder to your Magento 2 root directory
* In terminal change directory to your Magento 2 root directory using command
```
cd /FULL_PATH_TO_YOUR_MAGENTO2
```
* Run Magento 2 upgrade command
```
php bin/magento setup:upgrade
```

Configuration
-------------

* System configuration
** Configure Janolaw credentinals in Stores > Configuration > Janolaw > AGB-Hosting
*** Enabled - yes
*** User-ID
*** Shop-ID
** Set for each store view used language. Currently module supports 3 language: german, english, french
** It is possible to attach email for outgoing order emails:
*** Attach Terms-and-conditions as PDF document 
*** Attach Revocation-policy as PDF document 
*** Attach Withdrawal as PDF document
* Import data from Janolaw server
** Open Stores > Janolaw Agb Terms
** Click button Synchronize
* Insert the usage code in term and condition and email transaction template when you need


Changing styles provided by Janolaw
-----------------------------------
By default module downloads css styles from Janolaw server, store it in
app/code/Janolaw/Agb/view/frontend/web/css/agb.css file and enable this file in frontend.

It is possible to overwrite this file by placing new file in your theme. Create agb.css in
app/design/frontend/<Your_Vendor>/<your_theme>/Janolaw_Agb/web/css/agb.css


Uploading package
-----------------
Links:
* [Magento 2 package](http://devdocs.magento.com/guides/v2.0/extension-dev-guide/package_module.html)
* [Magento 2 connect](https://www.magentocommerce.com/magento-connect/magento-2)

Change log
----------
v1.3.1 2019-10-10

* Added compatibility with Magento 2 v2.3.2

v1.3.0 2018-11-27

* Magento 2.3.0 ONLY!

v1.2.1 2018-03-02

* Added check for Extensions that override the Magento 2 Framework TransportBuilder Class, so no conflicts occur during runtime

v1.2.0 2017-08-23

* Add PDF attachment for Data privacy

v1.0.1 2017-02-23

* Compatibility with Magento 2.1

v1.0.0 2016-01-10

* Compatibility with Magento 2.0


v0.2.2 2015-07-20

* Compatibility with Janolaw Hosting Service v3 (including languages EN and FR, including pdf documents)

v0.1.6 2014-08-05

* Major refactoring
* Moved and refactored script `update.php` to `shell` directory. It must be called as
  `php -f shell/janolaw.php -- update` (instead of `php app/code/community/Janolaw/update_agb.php`)
* Save content for existing blocks of *all* stores. In earlier versions, we only fetched data for
  default stores of store groups..
* Drop support for storing content directly in cms pages. Instead everything is stored in cms blocks, and you need to
  include cms blocks into pages. See *Compatibility with third party modules* above for details.


v0.1.4  2014-07-28

Old version which required Market Ready Germany
