<?php

namespace Janolaw\Agb\Helper;

use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\Filesystem;
use Magento\Framework\App\Helper\Context;

class File extends AbstractHelper
{
    const LOCAL_PDF_BASE_PATH = 'janolawagb_pdf';


    /**
     * @var Filesystem
     */
    protected $_filesystem;

    /**
     * Construct
     *
     * @param Context $context
     * @param Filesystem $filesystem
     */
    public function __construct(
        Context $context,
        Filesystem $filesystem
    ) {
        parent::__construct($context);
        $this->_filesystem = $filesystem;
    }

    /**
     * @return string
     */
    public function getAbsModulePath()
    {
        return $this->_filesystem->getDirectoryRead(DirectoryList::APP)
            ->getAbsolutePath('code/Janolaw/Agb');
    }

    /**
     * @return string
     */
    public function getLocalPdfBasePath()
    {
        $pdfDir = $this->_filesystem->getDirectoryRead(DirectoryList::MEDIA)
            ->getAbsolutePath(self::LOCAL_PDF_BASE_PATH);

        if (!is_dir($pdfDir)) {
            mkdir($pdfDir, 0755, true);
        }

        return $pdfDir;
    }
}
