<?php

namespace Janolaw\Agb\Model\Overwrite;

class OrderSender extends \Magento\Sales\Model\Order\Email\Sender\OrderSender
{
    /**
     * @var \Janolaw\Agb\Model\AttachmentContainer
     */
    protected $attachmentContainer;

    /**
     * @var \Magento\Framework\Module\Manager
     */
    protected $moduleManager;

    /**
     * Lists SMTP Modules that overwrite TransportBuilder in Magento Framework
     * @var array
     */
    private $smtpModules = [
        'Mageplaza_Smtp',
        'Fooman_EmailAttachments'
    ];

    /**
     * OrderSender constructor.
     * @param \Magento\Sales\Model\Order\Email\Container\Template $templateContainer
     * @param \Magento\Sales\Model\Order\Email\Container\OrderIdentity $identityContainer
     * @param \Magento\Sales\Model\Order\Email\SenderBuilderFactory $senderBuilderFactory
     * @param \Psr\Log\LoggerInterface $logger
     * @param \Magento\Sales\Model\Order\Address\Renderer $addressRenderer
     * @param \Magento\Payment\Helper\Data $paymentHelper
     * @param \Magento\Sales\Model\ResourceModel\Order $orderResource
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $globalConfig
     * @param \Magento\Framework\Event\ManagerInterface $eventManager
     * @param \Janolaw\Agb\Model\AttachmentContainer $attachmentContainer
     * @param \Magento\Framework\Module\Manager $moduleManager
     */

    public function __construct(
        \Magento\Sales\Model\Order\Email\Container\Template $templateContainer,
        \Magento\Sales\Model\Order\Email\Container\OrderIdentity $identityContainer,
        \Magento\Sales\Model\Order\Email\SenderBuilderFactory $senderBuilderFactory,
        \Psr\Log\LoggerInterface $logger,
        \Magento\Sales\Model\Order\Address\Renderer $addressRenderer,
        \Magento\Payment\Helper\Data $paymentHelper,
        \Magento\Sales\Model\ResourceModel\Order $orderResource,
        \Magento\Framework\App\Config\ScopeConfigInterface $globalConfig,
        \Magento\Framework\Event\ManagerInterface $eventManager,
        \Janolaw\Agb\Model\AttachmentContainer $attachmentContainer,
        \Magento\Framework\Module\Manager $moduleManager
    ) {
        parent::__construct(
            $templateContainer,
            $identityContainer,
            $senderBuilderFactory,
            $logger,
            $addressRenderer,
            $paymentHelper,
            $orderResource,
            $globalConfig,
            $eventManager
        );
        $this->attachmentContainer = $attachmentContainer;
        $this->moduleManager = $moduleManager;
    }


    public function send(\Magento\Sales\Model\Order $order, $forceSyncMode = false)
    {
        if(false)
        {
            /*$this->eventManager->dispatch(
                'janolaw_attachmentsinmail_before_send_order',
                [
                    'thisClass' => $this,
                    'content_container' => $this->attachmentContainer,
                    'order' => $order
                ]
            );*/
        } else {
            $this->eventManager->dispatch(
                'janolaw_emailattachments_before_send_order',
                [
                    'attachment_container' => $this->attachmentContainer,
                    'order' => $order
                ]
            );
        }
        return parent::send($order, $forceSyncMode);
    }

    /**
     * Checks if an SMTP Module is enabled that overwrites TransportBuilder in Magento Framework
     *
     * @return bool
     */
    private function isSmtpModuleEnabled()
    {
        $check = false;
        foreach($this->smtpModules as $module)
        {
            if($this->moduleManager->isEnabled($module))
            {
                $check = true;
            }
        }
        return $check;
    }
}
