<?php
namespace Janolaw\Agb\Observer;

use \Janolaw\Agb\Model\AttachmentContainer;
use \Magento\Framework\Event\ObserverInterface;
use \Magento\Framework\App\Config\ScopeConfigInterface;

abstract class AbstractAttachmentObserver implements ObserverInterface
{
    protected $attachmentFactory;

    protected $logger;

    protected $downloadFactory;

    protected $scopeConfig;

    /**
     * @param ScopeConfigInterface $scopeConfig
     * @param \Psr\Log\LoggerInterface $logger
     * @param \Janolaw\Agb\Model\DownloadFactory $downloadFactory
     * @param \Janolaw\Agb\Model\AttachmentFactory $attachmentFactory
     */
    public function __construct(
        ScopeConfigInterface $scopeConfig,
        \Psr\Log\LoggerInterface $logger,
        \Janolaw\Agb\Model\DownloadFactory $downloadFactory,
        \Janolaw\Agb\Model\AttachmentFactory $attachmentFactory
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->logger = $logger;
        $this->downloadFactory = $downloadFactory;
        $this->attachmentFactory = $attachmentFactory;
    }

    public function attachContent($content, $pdfFilename, $mimeType, AttachmentContainer $attachmentContainer)
    {
        $attachment = $this->attachmentFactory->create(
            [
                'content' => $content,
                'mimeType' => $mimeType,
                'fileName' => $pdfFilename
            ]
        );
        $attachmentContainer->addAttachment($attachment);
    }

    public function attachPdf($pdfString, $pdfFilename, AttachmentContainer $attachmentContainer)
    {
        $this->attachContent($pdfString, $pdfFilename, 'application/pdf', $attachmentContainer);
    }
}
