<?php
namespace Janolaw\Agb\Observer;

use \Magento\Framework\Event\Observer;
use \Janolaw\Agb\Model\Download;

class BeforeSendOrderSmtpObserver extends AbstractAttachmentObserver
{
    public function execute(Observer $observer)
    {
        /** @var  $order \Magento\Sales\Api\Data\OrderInterface */
        $order = $observer->getOrder();

        /** @var Download $download */
        $download = $this->downloadFactory->create();
        $pdfTypes = [
            Download::TYPE_TAC,
            Download::TYPE_PRIVACY,
            Download::TYPE_REVOCATION,
            Download::TYPE_WITHDRAWAL
        ];

        foreach ($pdfTypes as $pdfType) {
            if ($download->canAttachPdfByType($pdfType, $order->getStoreId())) {
                $pdfFile = $download->getLocalPdfFile($pdfType, $order->getStoreId());
                $language = $download->getLanguage($order->getStoreId());
                $pdfTitle = $download->getLabel($pdfType, $language);
                $pdfName = $pdfTitle . '.pdf';

                if ($pdfFile) {
                    $this->attachContentInline(
                        file_get_contents($pdfFile),
                        $observer->getContentContainer()
                    );
                }
            }
        }
    }

}
