<?php
/*
Plugin Name: Janolaw AGB Hosting
Plugin URI: http://www.janolaw.de/internetrecht/agb/agb-hosting-service/
Description: This Plugin get hosted legal documents provided by Janolaw AG
Version: 2.0
Author: Jan Giebels
Author URI: http://conspir3d.com
Compatible: Kirby CMS 2.3.2



Available types for content pages
    terms
    legaldetails
    revocation
    datasecurity
    model-withdrawal-form

Available languages codes for Serice Version 3
    de - Deutsch
    gb - English
    fr - Francaise
*/

$user_id = '100xxx';
$shop_id = 'xxx';

$language = 'de'; # de, (gb, fr - only available in service version 3)
$pdflink = true; # only available in service version 3
$cache_path = '/tmp'; # path must be writable

#############################################
# --- DO NOT CHANGE ANYTHING BELOW HERE --- #
#############################################
$cache_time = 7200;
$base_url = 'http://www.janolaw.de/agb-service/shops';

# check for version
$version = 2;
if (file_get_contents($base_url.'/'.$user_id.'/'.$shop_id.'/'.$language.'/'.$type.'.pdf',0,null,0,1)) {
    $version = 3;
}

# get document
if (file_exists($cache_path.'/'.$user_id.$shop_id.'janolaw_'.$type.'.html')) {
    if (filectime($cache_path.'/'.$user_id.$shop_id.'janolaw_'.$type.'.html')+$cache_time<=time()) {
            #get fresh version from server 
            if ($file = file_get_contents($base_url.'/'.$user_id.'/'.$shop_id.'/'.$language.'/'.$type.'_include.html')) {
                    unlink ($cache_path.'/'.$user_id.$shop_id.'janolaw_'.$type.'.html');
                    $fp = fopen($cache_path.'/'.$user_id.$shop_id.'janolaw_'.$type.'.html', 'w');
                    fwrite($fp, $file);
                    fclose($fp);
            }
    }
} else {
    $file = file_get_contents($base_url.'/'.$user_id.'/'.$shop_id.'/'.$type.'_include.html');
    $fp = fopen($cache_path.'/'.$user_id.$shop_id.'janolaw_'.$type.'.html', 'w');
    fwrite($fp, $file);
    fclose($fp);
}

# extract text
if ($file = file_get_contents($cache_path.'/'.$user_id.$shop_id.'janolaw_'.$type.'.html')) {
    echo $file;

    # display PDF link
    if (($pdflink == true) && ($version == 3)) {
        echo "<a class='janolaw-pdflink' href='".$base_url.'/'.$user_id.'/'.$shop_id.'/'.$language.'/'.$type.".pdf' target='_blank'>Download PDF</a>";
    }

    # display PDF link for withdrawal form in version 3
    if (($pdflink == true) && ($version == 3) && ($type == 'revocation')) {
        echo "<br /><a class='janolaw-pdflink' href='".$base_url.'/'.$user_id.'/'.$shop_id.'/'.$language."/model-withdrawal-form.pdf' target='_blank'>Download Form PDF</a>";
    }

} else {
    echo "<div class='error'>Fehler: Die Cache Datei konnte nicht gelesen werden oder hat keinen Inhalt</div>";
}
